

CompScans_AlltoAll <- function(datafA,dataf){

  datafA$Unique_scan <- datafA$Spectrum
  datafA$Sequence <- datafA$Peptide
  dataf$Unique_scan <- dataf$Spectrum
  dataf$Sequence <- dataf$Peptide
  datafA$PTM_final_prob <- datafA$PTM.Score*datafA$Score
  dataf$PTM_final_prob <- dataf$PTM.Score*dataf$Score
  datafA$Amino <- str_sub(substr(datafA$Sequence,1,datafA$PTM.positions),-1)
  dataf$Amino <- str_sub(substr(dataf$Sequence,1,dataf$PTM.positions),-1)
  dataf$nPhos <- str_count(dataf$All_PTMs, "Phospho")

ReduceddatafA <- subset(datafA,select = c(Unique_scan,Sequence,Amino,PTM_final_prob, PTM.positions, Score, PTM.Score))

ReduceddatafA <- ReduceddatafA %>% dplyr::rename(
  pASTY_Score = PTM_final_prob,
  pASTY_PSMScore = Score,
  pASTY_PTMScore = PTM.Score
)
Reduceddataf <- subset(dataf,select = c(Unique_scan,Sequence,PTM_final_prob, PTM.positions, Score, PTM.Score, nPhos))

Reduceddataf <- Reduceddataf %>% dplyr::rename(
  SequenceSTY = Sequence,
  PTM.positionsSTY= PTM.positions,
  pSTY_Score = PTM_final_prob,
  pSTY_PSMScore = Score,
  pSTY_PTMScore = PTM.Score
)


dataf_Merged <- merge(x=ReduceddatafA,y=Reduceddataf,by="Unique_scan", all.x = TRUE)
dataf_Merged<- dataf_Merged %>% group_by(Unique_scan) %>% dplyr::mutate(count_S = n())
dataf_Merged<- dataf_Merged %>% group_by(Unique_scan) %>% dplyr::mutate(count_M = n_distinct(PTM.positions))


dataf_Merged$SeqMatch <- ifelse(dataf_Merged$Sequence==dataf_Merged$SequenceSTY,1,0)
dataf_Merged$PTM_Match <- ifelse(dataf_Merged$Sequence==dataf_Merged$SequenceSTY&dataf_Merged$PTM.positions==dataf_Merged$PTM.positionsSTY,1,0)
dataf_Merged$SiteID <- paste0(dataf_Merged$Unique_scan,"_", dataf_Merged$PTM.positions)
dataf_Merged <- dataf_Merged %>% distinct(SiteID, .keep_all = TRUE)
return(dataf_Merged)

}
